<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Ongkirmember extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'member_id',
        'ongkir_id',
        'alamat',
        'sts_alamat',
    ];

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class);
    }

    public function ongkir(): BelongsTo
    {
        return $this->belongsTo(Ongkir::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
